/*
 * Decompiled with CFR 0.152.
 */
package emulator.hardware.nmos6502.operands;

import emulator.assembler.SymbolTable;
import emulator.hardware.HwByte;
import emulator.hardware.HwWord;
import emulator.hardware.nmos6502.Cpu6502;
import emulator.hardware.nmos6502.Operand;
import emulator.hardware.nmos6502.operands.OperandException;
import emulator.support.NullOperandEval;
import emulator.support.OperandEval;
import emulator.util.MemoryPtr;

public class Accumulator
implements Operand {
    Cpu6502 cpu;

    @Override
    public HwByte getByte() {
        return this.cpu.getAccu();
    }

    @Override
    public HwWord getWord() throws OperandException {
        throw new OperandException("getWord() on accumulator called", this);
    }

    @Override
    public void init(Cpu6502 cpu) {
        this.cpu = cpu;
    }

    @Override
    public void setByte(HwByte data) {
        this.cpu.setAccu(data);
    }

    @Override
    public void setWord(HwWord data) throws OperandException {
        throw new OperandException("setWord() on accumulator called", this);
    }

    @Override
    public String getString() {
        return "A";
    }

    @Override
    public int getByteCount() {
        return 0;
    }

    @Override
    public String getString(MemoryPtr mem_ref, SymbolTable symbols) {
        return "A";
    }

    @Override
    public int getExtraCycles() {
        return 0;
    }

    @Override
    public OperandEval getEvaluator(MemoryPtr mem_ref) {
        return new NullOperandEval();
    }
}

